//Richard Penner - Saves
// r3.0 shipped with Node.js v9.7.1 
// https://nodejs.org/docs/v9.7.1/api/ 
// r3.0 shipped with some version of NW.js 
// http://docs.nwjs.io/en/latest/References/App/#appdatapath 
// r3.0 shipped with a package.json with name = "" which 
// has consequences if gui.App.dataPath relates to 
// the above reference 
// Because StorageManager.localFilePath() just concatenates 
// strings, localFileDirectoryPath must return a string 
// ending in a file separator. 


 
StorageManager.localFileDirectoryPath = function() {
	if (ConfigManager.alwaysDash) {
    var path = require('path');
    var base = path.dirname(process.mainModule.filename);
    return path.join(base, 'save/');
	}
	else {
		var fs = require('fs');
		var gui = require('nw.gui');
		var path = require('path');
		var extra = 'Lust Doll Plus';
		 
	// Because I don't have docs for nw.gui, I need to 
	// ensure this directory exists

		if ( ! fs.existsSync( gui.App.dataPath ) ) {
			fs.mkdirSync(gui.App.dataPath, {recursive: true} )
		};

	// node.js 9.x introduced recursive } 
	// other parts of StorageManager will guarantee that the 
	// extra (so long as it consists of only one component) 
	// gets created 

		return path.join( gui.App.dataPath, extra ) + path.sep;
	}
}



/*
//carrie vers
StorageManager.localFileDirectoryPath = function() {
	if (ConfigManager.alwaysDash) {
    var path = require('path');
    var base = path.dirname(process.mainModule.filename);
    return path.join(base, 'save/');
	}
	else {
		var gui = require('nw.gui');
		return gui.App.dataPath + "\\Lust Doll Plus\\";
	}
};
*/


